/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer(1000, 16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int capacityMb;
    private final int width;
    private final int height;
    private final int minHeight;

    public FluidRenderer(int capacityMb, int width, int height, int minHeight) {
        this.capacityMb = capacityMb;
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.m_118409_();
        double uMax = textureSprite.m_118410_();
        double vMin = textureSprite.m_118411_();
        double vMax = textureSprite.m_118412_();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(xCoord, yCoord + 16.0, zLevel).m_7421_((float)uMin, (float)vMax).m_5752_();
        bufferBuilder.m_5483_(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).m_7421_((float)uMax, (float)vMax).m_5752_();
        bufferBuilder.m_5483_(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).m_7421_((float)uMax, (float)vMin).m_5752_();
        bufferBuilder.m_5483_(xCoord, yCoord + (double)maskTop, zLevel).m_7421_((float)uMin, (float)vMin).m_5752_();
        tessellator.m_85914_();
    }

    public void render(int xPosition, int yPosition, @Nonnull FluidStack fluidStack) {
        RenderSystem.m_69478_();
        this.drawFluid(xPosition, yPosition, fluidStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    private void drawFluid(int xPosition, int yPosition, @Nonnull FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite fluidStillSprite = FluidRenderer.getStillFluidSprite(fluidStack);
        FluidAttributes attributes = fluid.getAttributes();
        int fluidColor = attributes.getColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * this.height / this.capacityMb;
        if (amount > 0 && scaledAmount < this.minHeight) {
            scaledAmount = this.minHeight;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(xPosition, yPosition, this.width, this.height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0);
            }
        }
    }
}

